


'===============================================================================
'                                   ATMEGA_328P
'===============================================================================
  $map       '      Bascom
  $regfile = "m328pdef.dat"       'http://www.atmel.com/images/Atmel-8271-8-bit-AVR-Microcontroller-ATmega48A-48PA-88A-88PA-168A-168PA-328-328P_datasheet_Complete.pdf
  $crystal = 8000000
  $framesize = 64       '       
  $hwstack = 64       '   
  $swstack = 64       '   

'===============================================================================
'                                   i2c
'===============================================================================
 '1 -   ( -  )
 '2 -   ( -  )
  Const Variant_realizacii_i2c = 1

  #if Variant_realizacii_i2c = 1
      $lib "i2c_twi.lbx"       '        I2c  ,     I2c      
      ' SCL  SDA,   !!!
      Config Sda = Portc.4       '   Sda
      Config Scl = Portc.5       '   Scl
      Config Twi = 20000       '    I2c   
  #endif

  #if Variant_realizacii_i2c = 2
      Config Sda = Portc.4       '   Sda
      Config Scl = Portc.5       '   Scl
      Config I2cdelay = 10       '    I2c   
  #endif

  I2cinit       '   I2c
  Waitms 50

'===============================================================================
'                                  
'===============================================================================
  $lib "lcd_HD44780_pcf8574.lib"

  Config Lcd = 20 * 4       '   LCD

'--------------------         ---------------------
  Dim _backlight As Byte : _backlight = 0       '    
   Alias _backlight
  Dim _lcd_e As Byte : _lcd_e = 192       ' !!!  ,    !!!

  Const Pcf8574_lcd = &H40       '  PCF8574

'+-----------------------------------------------------------------+
'|             |  PCF8574,PCF8574N, PCF8575 |  PCF8574A, PCF8574AP |
'|-------------|----------------------------|----------------------|
'|  A0  A1  A2 |     Write   |     Read     |    Write  |   Read   |
'|-------------|-------------|--------------|-----------|----------|
'|  0   0   0  |      &H40   |     &H41     |    &H70   |   &H71   |
'|  1   0   0  |      &H42   |     &H43     |    &H72   |   &H73   |
'|  0   1   0  |      &H44   |     &H45     |    &H74   |   &H75   |
'|  1   1   0  |      &H46   |     &H47     |    &H76   |   &H77   |
'|  0   0   1  |      &H48   |     &H49     |    &H78   |   &H79   |
'|  1   0   1  |      &H4A   |     &H4B     |    &H7A   |   &H7B   |
'|  0   1   1  |      &H4C   |     &H4D     |    &H7C   |   &H7D   |
'|  1   1   1  |      &H4E   |     &H4F     |    &H7E   |   &H7F   |
'+-----------------------------------------------------------------+

'----------------     PCF8574x   ----------------------------
  Const Pcf_rs = 6       ' RS
  Const Pcf_bl = 7       ' 
  Const Pcf_e2 = 4       ' 
  Const Pcf_e1 = 5       '   
 '-----------------------------------------
  Const Pcf_d4 = 0       ' D4
  Const Pcf_d5 = 1       ' D5
  Const Pcf_d6 = 2       ' D6
  Const Pcf_d7 = 3       ' D7


  Initlcd       '   LCD
  Cursor Off       '  
  Cls       '  ,   ,   

'-----------------------  _--------------------------------
 Deflcdchar 1 , 12 , 18 , 18 , 12 , 32 , 32 , 32 , 32       ' 
' Deflcdchar 5 , 14 , 10 , 10 , 10 , 14 , 31 , 31 , 14       '
'  Deflcdchar 6 , 4 , 5 , 15 , 20 , 4 , 14 , 10 , 27           '
'  Deflcdchar 7 , 232 , 244 , 232 , 227 , 228 , 228 , 227 , 224       ' 
'  Deflcdchar 8 , 2 , 6 , 30 , 30 , 30 , 6 , 2 , 32            '
'  Deflcdchar 9 , 32 , 25 , 11 , 4 , 26 , 19 , 32 , 32        ' 
'  Deflcdchar 10 , 9 , 26 , 28 , 27 , 28 , 26 , 9 , 32         '  
'  Deflcdchar 1 , 31 , 27 , 19 , 27 , 27 , 17 , 31 , 31       ' 1
'  Deflcdchar 2 , 31 , 17 , 29 , 27 , 23 , 17 , 31 , 31       ' 2
'  Deflcdchar 3 , 31 , 17 , 29 , 27 , 29 , 17 , 31 , 31       ' 3
'  Deflcdchar 4 , 31 , 21 , 21 , 17 , 29 , 29 , 31 , 31       ' 4
'  Deflcdchar 5 , 31 , 17 , 23 , 17 , 29 , 17 , 31 , 31       ' 5
'  Deflcdchar 6 , 31 , 17 , 23 , 17 , 21 , 17 , 31 , 31       ' 6
'  Deflcdchar 7 , 31 , 17 , 29 , 27 , 23 , 23 , 31 , 31       ' 7
'  Deflcdchar 8 , 31 , 17 , 21 , 17 , 21 , 17 , 31 , 31       ' 8
'  Deflcdchar 9 , 31 , 17 , 21 , 17 , 29 , 17 , 31 , 31       ' 9
'  Deflcdchar 0 , 31 , 17 , 21 , 21 , 21 , 17 , 31 , 31       ' 0

'===============================================================================
'                                      
'===============================================================================
  Dim __lcd As Byte

'===============================================================================
'                                  
'===============================================================================
  Declare Sub Print_lcd(byval Copy_ As Byte , Byval Copy_ As Byte , Byval Copy_buffer_lcd As String)       '      LCD HD44780

'--------       "SQW/OUT" Ds3231  --------

  Config Pind.2 = Input       '    
  Config Int0 = Rising       '        Rising (  ) ; Falling (  ) ; Low Level (  )

'      INT0,     Ds3231

  On Int0 __ds3231 Nosave       '         Ds3231

'-----------------     Ds3231  -------------------------

  Const _ds3231 = &HD0       '     Ds3231
  Const _ds3231 = &HD1       '     Ds3231

'------------        Ds3231  ----------------

  Const Const_ = 0       '  
  Const Const_ = 1       '  
  Const Const_ = 2       '  
  Const Const__ = 3       '  _
  Const Const__ = 4       '  _
  Const Const_ = 5       '  
  Const Const_ = 6       '  

  Const Const_alarm_1_seconds = 7       '    1
  Const Const_alarm_1_minutes = 8       '    1
  Const Const_alarm_1_hours = 9       '    1
  Const Const_alarm_1_day = 10       '  4 ,     1
  Const Const_alarm_1_date = 10       '  4 ,     1

  Const Const_alarm_2_minutes = 11       '    2
  Const Const_alarm_2_hours = 12       '    2
  Const Const_alarm_2_day = 13       '  4 ,     2
  Const Const_alarm_2_date = 13       '  4 ,     2

  Const Control_register = 14
  Const Status_register = 15
  Const Const_aging_offset = 16

  Const Const__high = 17       '     
  Const Const__low = 18       '   
  Const Const__ = 2.65       '  



  Const Const_stop_ = &B10000000       '     
  Const Const_start_ = &B00000000       '     

'         SQW/OUT      &B00100000
'        BIT 7 BIT 6 BIT 5 BIT 4 BIT 3 BIT 2 BIT 1 BIT 0
'NAME:    EOSC BBSQW CONV RS2 RS1 INTCN A2IE A1IE
'Por : 0 0 0 1 1 1 0 0
  Const Const__sout_ds3231 = &B00000000       '     1    SQW/OUT - (    )
'                                        ||||||||
'                                        |||||||+--- 0 - A1IE - Alarm 1 Interrupt Enable (A1IE)
'                                        ||||||+---- 1 - A2IE - Alarm 2 Interrupt Enable (A2IE)
'                                        |||||+----- 2 - INTCN - Interrupt Control (INTCN)
'                                        ||||+------ 3 - RS1   - Rate Select (RS2 and RS1)
'                                        |||+------- 4 - RS2   - Rate Select (RS2 and RS1)
'                                        ||+-------- 5 - CONV  - Convert Temperature (CONV)
'                                        |+--------- 6 - BBSQW - Battery-Backed Square-Wave Enable
'                                        +---------- 7 - EOSC  - Enable Oscillator (EOSC), 0 - , 1 
' :
'  Const Const__sout_ds1307 = &B00000000       '     1    SQW/OUT
'  Const Const__sout_ds1307 = &B00001000       '     1,024    SQW/OUT
'  Const Const__sout_ds1307 = &B00010000       '     4,096    SQW/OUT
'  Const Const__sout_ds1307 = &B00011000       '     8,192    SQW/OUT


'  Const Const__ds1307 = 7       '    Ds1307
'  Const Const_stop_ = &B10000000       '     
'  Const Const_start_ = &B00000000       '     
'  Const Const__sout_ds1307 = &B10010000       '      

'===============================================================================
'                                      
'===============================================================================

  Dim __ds3231 As Byte

  Dim  As Byte
  Dim  As Byte
  Dim  As Byte
  Dim  As Byte
  Dim  As Byte
  Dim _ As Byte
  Dim _ As Byte

  Dim _str As String * 4
  Dim _str As String * 2
  Dim _str As String * 8
  Dim _str As String * 2
  Dim _str As String * 2
  Dim __str As String * 11
  Dim __str As String * 2


  Dim __ As Byte
  Dim __ As Byte
  Dim __ As Byte

  Dim __str As String * 8 : __str = " 0:00:00"
  Dim ___str As String * 2 : ___str = " 0"
  Dim ___str As String * 2 : ___str = "00"
  Dim ___str As String * 2 : ___str = "00"


  Dim _str As String * 8
  Dim _str As String * 32

  Dim _low As Byte
  Dim _high As Byte

  Dim _ As Byte
  Dim _ As Byte
  Dim __sin As Single

  Dim __single As Single
  Dim Temp__single_1 As Single

  Dim __str As String * 10


  Dim _status_register As Byte
  Dim _control_register As Byte

  Dim 1__ As Byte
  Dim 1__ As Byte
  Dim 1__ As Byte
  Dim 1___ As Byte
  Dim 1__ As Byte
  Dim 1__ As Byte

  Dim 2__ As Byte
  Dim 2__ As Byte
  Dim 2___ As Byte
  Dim 2__ As Byte
  Dim 2__ As Byte


  Dim _lcd_1__str As String * 20
  Dim _lcd_2__str As String * 20
  Dim _lcd_3__str As String * 20
  Dim _lcd_4__str As String * 20

'===============================================================================
'                                  
'===============================================================================

'\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\
'                                           
'\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\

  1__ = 0
  1__ = 0
  1__ = 17
  1___ = 25
  1__ = 10
  1__ = 14

  2__ = 2
  2__ = 17
  2___ = 25
  2__ = 10
  2__ = 14

  1__ = Makebcd(1__)       ' 
  1__ = Makebcd(1__)       ' 
  1__ = Makebcd(1__)       ' 
  1__ = Makebcd(1__)       ' 
  1__ = Makebcd(1__)       ' 
  1___ = Makebcd(1___)       ' 

  2__ = Makebcd(2__)       ' 
  2__ = Makebcd(2__)       ' 
  2__ = Makebcd(2__)       ' 
  2__ = Makebcd(2__)       ' 
  2___ = Makebcd(2___)       ' 

  I2cstart       '     I2c
  I2cwbyte _ds3231       '      i2c,  
  I2cwbyte Const_alarm_1_seconds       '  ,     
  I2cwbyte 1__       '  
  I2cwbyte 1__       '  
  I2cwbyte 1__       '  
  I2cwbyte 1___       '  
  I2cwbyte 1__       '  
  I2cwbyte 1__       '  
  I2cwbyte 2__       '  
  I2cwbyte 2__       '  
  I2cwbyte 2___       '  
  I2cwbyte 2__       '  
  I2cwbyte 2__       '  
  I2cstop       '   I2c

'     1    
  I2cstart       '   a
  I2cwbyte _ds3231
  I2cwbyte Control_register
  I2cwbyte &B_0000_0011       ' Const__sout_ds3231
  I2cstop

  I2cstart       '   
  I2cwbyte _ds3231
  I2cwbyte Status_register
  I2cwbyte &B_0000_0000
  I2cstop

'' ###################################################################################################################
'' ###################################################################################################################
'' ###################################################################################################################

'     Ds3231

'' ###################################################################################################################
'' ###################################################################################################################
'' ###################################################################################################################


'   = 0
'   = 21
'   = 15
'  _ = 1
'  _ = 8
'   = 3
'   = 15

'   = Makebcd()       ' 
'   = Makebcd()       ' 
'   = Makebcd()       ' 
'   = Makebcd()       ' 
'   = Makebcd()       ' 
'  _ = Makebcd(_)       '  
'  _ = Makebcd(_)       ' 

' '     Ds3231
'  I2cstart       '     I2c
'  I2cwbyte _ds3231       '      i2c,  
'  I2cwbyte Const_       '  ,     
'  I2cwbyte        '  
'  I2cwbyte        '  
'  I2cwbyte        '  
'  I2cwbyte _       '  
'  I2cwbyte _       '  
'  I2cwbyte        '  
'  I2cwbyte        '  
'  I2cstop       '   I2c



'' ###################################################################################################################
'' ###################################################################################################################
'' ###################################################################################################################



  Gosub _all_ds3231
  Gosub __ds3231

  Reset        '  ,  Reset, ..,    PCF8574  
  Print_lcd 1 , 1 , "  "
  Print_lcd 2 , 1 , " LCD    i2c "
  Print_lcd 3 , 1 , "Atmega328P + Ds3231 "
  Print_lcd 4 , 1 , "    PCF8574    "
  Wait 2
  Cls

'--------------       ----------------------
  Enable Int0
'------------        --------------------
  Enable Interrupts
'-------------------------------------------------------------------------------

'\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\
'===============================================================================
'                                     
  _:
'===============================================================================


     If __ds3231 <> 0 Then
         Gosub _all_ds3231
         If  = 0 Then       '    Ds3231,    1     
             Gosub __ds3231
         End If
         Gosub _status_register
         Gosub _control_register
         Gosub _
         __lcd = 1
         __ds3231 = 0
         Goto _
     End If



     If __lcd <> 0 Then
         Gosub _lcd
         __lcd = 0
         Goto _
     End If



     nop

   Idle       '     
'===============================================================================
  Goto _
 End
'===============================================================================
'                                       
'===============================================================================

'===============================================================================
  _lcd:
'-------------------------------------------------------------------------------
    __str = ___str + ":" + ___str + ":" + ___str
    _str = _str + ":" + _str + ":" + _str
    _str = __str + " " + _str


    _lcd_1__str = _str + "    " + __str
    _lcd_2__str = "    " + __str
    _lcd_3__str = "     " + _str
    _lcd_4__str = " t Ds3231: " + __str

    Print_lcd 1 , 1 , _lcd_1__str
    Print_lcd 2 , 1 , _lcd_2__str
    Print_lcd 3 , 1 , _lcd_3__str
    Print_lcd 4 , 1 , _lcd_4__str
    Locate 4 , 18
    Lcd Chr(1) ; "C"
'-------------------------------------------------------------------------------
  Return
'===============================================================================


'===============================================================================
  _:
'-------------------------------------------------------------------------------
    Incr __
    If __ > 59 Then
        __ = 0
        Incr __
        ___str = Str(__)
        If __ < 10 Then ___str = "0" + ___str
        If __ > 59 Then
            __ = 0
            Incr __
            If __ > 23 Then
                __ = 0
            End If       ' If __ > 23 Then
            ___str = Str(__)
            If __ < 10 Then ___str = " " + ___str
        End If       ' If __ > 59 Then
    End If       ' If __ > 59 Then
    ___str = Str(__)
    If __ < 10 Then ___str = "0" + ___str
'-------------------------------------------------------------------------------
  Return
'===============================================================================


'===============================================================================
  _all_ds3231:
'-------------------------------------------------------------------------------
  '    Ds3231
    I2cstart       '     I2c
    I2cwbyte _ds3231       '      i2c,  
    I2cwbyte Const_       '      
    I2crepstart       '      I2c
    I2cwbyte _ds3231       '      i2c,  
    I2crbyte  , Ack       '      i2c
    I2crbyte  , Ack       '      i2c
    I2crbyte  , Ack       '      i2c
    I2crbyte _ , Ack       '      i2c
    I2crbyte _ , Ack       '      i2c
    I2crbyte  , Ack       '      i2c
    I2crbyte  , Nack       '      i2c
    I2cstop       '   I2c

     = Makedec()       ' 
     = Makedec()       ' 
     = Makedec()       ' 
     = Makedec()       ' 
     = Makedec()       ' 
    _ = Makedec(_)       '  
    _ = Makedec(_)       ' 

    _str = "20" + Str()
    _str = Lookupstr( , _)
    __str = Lookupstr(_ , __)
    If  < 10 Then _str = " " + Str() Else _str = Str()
    If  < 10 Then _str = "0" + Str() Else _str = Str()
    If  < 10 Then _str = "0" + Str() Else _str = Str()
    If _ < 10 Then __str = " " + Str(_) Else __str = Str(_)

    _str = _str + ":" + _str + ":" + _str
    _str = __str + " " + __str + " " + _str + " " + _str + " "

'-------------------------------------------------------------------------------
  Return
'===============================================================================



'===============================================================================
'--     Ds3231,  , ,    !!!  --
'===============================================================================
  _ds3231:
'-------------------------------------------------------------------------------
    I2cstart       '     I2c
    I2cwbyte _ds3231       '   
    I2cwbyte Const_       '      - 0
    I2cstart       '     I2c
    I2cwbyte _ds3231       '    Ds3231
    I2crbyte  , Nack       '    (- )
    I2cstop       '   I2c

     = Makedec()       ' 
    If  < 10 Then _str = "0" + Str() Else _str = Str()

    If  = 0 Then
        I2cstart       '     I2c
        I2cwbyte _ds3231       '   
        I2cwbyte Const_       '      - 0
        I2cstart       '     I2c
        I2cwbyte _ds3231       '    Ds3231
        I2crbyte  , Nack       '    (- )
        I2cstop       '   I2c

         = Makedec()       ' 
        If  < 10 Then _str = "0" + Str() Else _str = Str()


        Gosub __ds3231


        If  = 0 Then
            I2cstart       '     I2c
            I2cwbyte _ds3231       '   
            I2cwbyte Const_       '      - 0
            I2cstart       '     I2c
            I2cwbyte _ds3231       '    Ds3231
            I2crbyte  , Nack       '    (- )
            I2cstop       '   I2c

             = Makedec()       ' 
            If  < 10 Then _str = " " + Str() Else _str = Str()

            If  = 0 Then
                I2cstart       '     I2c
                I2cwbyte _ds3231       '   
                I2cwbyte Const__       '      - 0
                I2cstart       '     I2c
                I2cwbyte _ds3231       '    Ds3231
                I2crbyte _ , Ack
                I2crbyte _ , Ack
                I2crbyte  , Ack
                I2crbyte  , Nack
                I2cstop       '   I2c

                 = Makedec()       ' 
                 = Makedec()       ' 
                _ = Makedec(_)       '  
                _ = Makedec(_)       ' 

                __str = Lookupstr(_ , __)
                If _ < 10 Then __str = "0" + Str(_) Else __str = Str(_)
                _str = Lookupstr( , _)
                _str = "20" + Str()
            End If       ' If  = 0 Then
        End If       ' If  = 0 Then
    End If       ' If  = 0 Then
'-------------------------------------------------------------------------------
  Return
'===============================================================================


'===============================================================================
  _status_register:
'-------------------------------------------------------------------------------

    I2cstart       '     I2c
    I2cwbyte _ds3231       '      i2c,  
    I2cwbyte Status_register       '       
    I2crepstart       '      I2c
    I2cwbyte _ds3231       '      i2c,  
    I2crbyte _status_register , Nack       '      i2c,   ,   
    I2cstop       '   I2c

'-------------------------------------------------------------------------------
  Return
'===============================================================================



'===============================================================================
  _control_register:
'-------------------------------------------------------------------------------

    I2cstart       '     I2c
    I2cwbyte _ds3231       '      i2c,  
    I2cwbyte Control_register       '       
    I2crepstart       '      I2c
    I2cwbyte _ds3231       '      i2c,  
    I2crbyte _control_register , Nack       '      i2c,   ,   
    I2cstop       '   I2c

'-------------------------------------------------------------------------------
  Return
'===============================================================================


'===============================================================================
  __ds3231:
'-------------------------------------------------------------------------------

    I2cstart       '     I2c
    I2cwbyte _ds3231       '      i2c,  
    I2cwbyte &H11       '       
    I2crepstart       '      I2c
    I2cwbyte _ds3231       '      i2c,  
    I2crbyte _high , Ack       '      i2c   ,    
    I2crbyte _low , Nack       '      i2c,   ,   
    I2cstop       '   I2c

    Gosub __

    __str = Fusing(__single , "&.&")
    __str = Format(__str , "+   0")
    __str = __str

'-------------------------------------------------------------------------------
  Return
'===============================================================================


'===============================================================================
'      RTC Ds3231
'===============================================================================
  __:
'-------------------------------------------------------------------------------
    _ = _high And &B_1000_0000       '   7- ,    
    _ = _high And &B_0111_1111       '   6- ,     

    Shift _low , Right , 6       '    2- ,    
    __sin = _low * 0.25       '     


    If _ = 128 Then
        Temp__single_1 = _ + __sin
        __single = Temp__single_1 - 128
        __single = __single + Const__
      Else
        __single = _ + __sin
        __single = __single - Const__
    End If
'-------------------------------------------------------------------------------
  Return
'===============================================================================


'===============================================================================
'    RTC Ds3231
'===============================================================================
  __ds3231:
'-------------------------------------------------------------------------------
    !push R16
    !ldi R16 , 1
    !sts {__ds3231} , R16
    !pop R16
    !reti
'-------------------------------------------------------------------------------
  Return
'===============================================================================


'===============================================================================
 __:       '  
'-------------------------------------------------------------------------------
'    Data "" , "" , "" , "" , "" , "" , "" , ""
'-------------------------------------------------------------------------------

    Data " "       '          0
    Data ""       ' 1
    Data ""       ' 2
    Data ""       '          3
    Data ""       '          4
    Data ""       '          5
    Data ""       '          6
    Data ""       '          7

'   ,    ,       LCD   HD44780

'    Data " "        '          0
'    Data "Bocpecee"       ' 1
'    Data "oeeĽ"       ' 2
'    Data "Bop"  '          3
'    Data "Cpea"    '          4
'    Data "eep"  '          5
'    Data "ǿa"  '          6
'    Data "Cyoa"  '          7

'===============================================================================


'===============================================================================
  _:       '  
'-------------------------------------------------------------------------------
'    Data "" , "" , "" , "" , "" , "" , "" , "" , "" , "" , "" , "" , ""
'-------------------------------------------------------------------------------

    Data " "       ' 0
    Data ""       ' 1
    Data ""       ' 2
    Data ""       ' 3
    Data ""       ' 4
    Data ""       ' 5
    Data ""       ' 6
    Data ""       ' 7
    Data ""       ' 8
    Data ""       ' 9
    Data ""       ' 10
    Data ""       ' 11
    Data ""       ' 12

'   ,    ,      LCD   HD44780

'    Data " "        ' 0
'    Data "ap"   ' 1
'    Data "epa"  ' 2
'    Data "Mapa"    ' 3
'    Data "Ape"   ' 4
'    Data "Ma"      ' 5
'    Data "ƽ"     ' 6
'    Data "ƻ"     ' 7
'    Data "Ayca"  ' 8
'    Data "Ceǲp" ' 9
'    Data "Oǲp"  ' 10
'    Data "Hoǲp"   ' 11
'    Data "eap"  ' 12

'===============================================================================


'===============================================================================
'                LCD HD44780
'===============================================================================
  Sub Print_lcd(byval Copy_ As Byte , Byval Copy_ As Byte , Byval Copy_buffer_lcd As String)       '      LCD HD44780
'-------------------------------------------------------------------------------
    Local _ As Byte , _lcd_print As Byte , _ As Byte , __lcd As Byte
    Local  As Byte ,  As Byte
    Local _str As String * 1 , _lcd_str As String * 1 , __lcd_str As String * 20

     = Copy_
     = Copy_
    __lcd_str = ""

    _ = Len(copy_buffer_lcd)       '    
    If _ = 0 Then       ' Ec   "0",   
        Exit Sub       '    
    End If

    For _lcd_print = 1 To _       '     
        _str = Mid(copy_buffer_lcd , _lcd_print , 1)       '   1    
        _ = Asc(_str)       '    

        If _ > 191 Then
            __lcd = Lookup(_ , Cp1251_to_lcd_hd44780)       '      (  )
            _lcd_str = Chr(__lcd)       '     LCD   (  )
          Else
            _lcd_str = _str
        End If

        __lcd_str = __lcd_str + _lcd_str       '      LCD
    Next _lcd_print       '      

    Locate  ,        '     
    Lcd __lcd_str       '     LCD
'-------------------------------------------------------------------------------
  End Sub
'===============================================================================



'===============================================================================
'                Cp1251
'                   LCD
'===============================================================================
  Cp1251_to_lcd_hd44780:
'---------------   128   -------------------------------------------
    Data &H00 , &H01 , &H02 , &H03 , &H04 , &H05 , &H06 , &H07 , &H08 , &H09
    Data &H0A , &H0B , &H0C , &H0D , &H0E , &H0F , &H10 , &H11 , &H12 , &H13
    Data &H14 , &H15 , &H16 , &H17 , &H18 , &H19 , &H1A , &H1B , &H1C , &H1D
    Data &H1E , &H1F , &H20 , &H21 , &H22 , &H23 , &H24 , &H25 , &H26 , &H27
    Data &H28 , &H29 , &H2A , &H2B , &H2C , &H2D , &H2E , &H2F , &H30 , &H31
    Data &H32 , &H33 , &H34 , &H35 , &H36 , &H37 , &H38 , &H39 , &H3A , &H3B
    Data &H3C , &H3D , &H3E , &H3F , &H40 , &H41 , &H42 , &H43 , &H44 , &H45
    Data &H46 , &H47 , &H48 , &H49 , &H4A , &H4B , &H4C , &H4D , &H4E , &H4F
    Data &H50 , &H51 , &H52 , &H53 , &H54 , &H55 , &H56 , &H57 , &H58 , &H59
    Data &H5A , &H5B , &H20 , &H5D , &H5E , &H5F , &H60 , &H61 , &H62 , &H63
    Data &H64 , &H65 , &H66 , &H67 , &H68 , &H69 , &H6A , &H6B , &H6C , &H6D
    Data &H6E , &H6F , &H70 , &H71 , &H72 , &H73 , &H74 , &H75 , &H76 , &H77
    Data &H78 , &H79 , &H7A , &H5B , &H20 , &H5D , &HE9 , &H7F
'---------------   128   -------------------------------------------
    Data &H20 , &H20 , &H20 , &H20 , &H20 , &H20 , &H20 , &H20 , &H20 , &H20
    Data &H20 , &H20 , &H20 , &H20 , &H20 , &H20 , &H20 , &H20 , &H20 , &H20
    Data &H20 , &H20 , &H20 , &H20 , &H20 , &H20 , &H20 , &H20 , &H20 , &H20
    Data &H20 , &H20 , &HCB , &H20 , &H49 , &H69 , &H04 , &H20 , &HFE , &HEF
    Data &HA2 , &HCC , &H00 , &HC9 , &H20 , &H20 , &H20 , &H02 , &H00 , &H00
    Data &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &HB5 , &H4E , &H00 , &H00
    Data &H00 , &H00 , &H00 , &H00 , &H41 , &HA0 , &H42 , &HA1 , &HE0 , &H45
    Data &HA3 , &HA4 , &HA5 , &HA6 , &H4B , &HA7 , &H4D , &H48 , &H4F , &HA8
    Data &H50 , &H43 , &H54 , &HA9 , &HAA , &H58 , &HE1 , &HAB , &HAC , &HE2
    Data &HAD , &HAE , &H62 , &HAF , &HB0 , &HB1 , &H61 , &HB2 , &HB3 , &HB4
    Data &HE3 , &H65 , &HB6 , &HB7 , &HB8 , &HB9 , &HBA , &HBB , &HBC , &HBD
    Data &H6F , &HBE , &H70 , &H63 , &HBF , &H79 , &HE4 , &H78 , &HE5 , &HC0
    Data &HC1 , &HE6 , &HC2 , &HC3 , &HC4 , &HC5 , &HC6 , &HC7
'===============================================================================